
*************************************************************************************************************

* CENSO DE INFORMACIN AMBIENTAL ECONMICA EN GOBIERNOS AUTNOMOS DESCENTRALIZADOS PROVINCIALES AO 2018.
*** SINTAXIS DE TABULADOS GAD 2019.

*************************************************************************************************************

* CAPITULO I - GESTIN AMBIENTAL 2019


*Tabla 1. ESTRUCTURA ORGANIZACIONAL DE LOS GAD PROVINCIALES 

CTABLES
  /VLABELS VARIABLES=v1_1_a v1_1_b v1_1_c v1_1_d v1_1_e DISPLAY=LABEL
  /TABLE v1_1_a [C][COUNT F40.0] + v1_1_b [C][COUNT F40.0] + v1_1_c [C][COUNT F40.0] + v1_1_d 
    [C][COUNT F40.0] + v1_1_e [C][COUNT F40.0]
  /CATEGORIES VARIABLES=v1_1_a v1_1_b v1_1_c v1_1_d v1_1_e ORDER=A KEY=VALUE EMPTY=INCLUDE
 /TITLES
    TITLE='ESTRUCTURA ORGANIZACIONAL DE LOS GAD PROVINCIALES '
    CAPTION='BDD2_G_AMB_GAD_2018'.


*Tabla 2. PERSONAL CON EL QUE CONT  LA COMPETENCIA DE GESTIN AMBIENTAL 

CTABLES
  /VLABELS VARIABLES=v1_2_1 v1_2_2 DISPLAY=LABEL
  /TABLE v1_2_1 [S][SUM] + v1_2_2 [S][SUM]
  /TITLES
    TITLE='PERSONAL CON EL QUE CONT  LA COMPETENCIA DE GESTIN AMBIENTAL '
    CAPTION='BDD1_G_AMB_GAD_2018'.

*Tabla 2 por provincia.
CTABLES
  /VLABELS VARIABLES=codigo_gobierno1_2 v1_2_1 v1_2_2 DISPLAY=LABEL
  /TABLE codigo_gobierno1_2 [C] BY v1_2_1 [S][SUM, COLPCT.SUM PCT40.1] + v1_2_2 [S][SUM, COLPCT.SUM 
    PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno1_2 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
/TITLES
    TITLE='PERSONAL CON EL QUE CONT  LA COMPETENCIA DE GESTIN AMBIENTAL POR PROVINCIA'
    CAPTION='BDD1_G_AMB_GAD_2018'.

****** Tabla 3.
CTABLES
  /VLABELS VARIABLES=v1_2_4 v1_2_7 v1_2_8 DISPLAY=LABEL
  /TABLE v1_2_4 [S][SUM] + v1_2_7 [S][SUM] + v1_2_8 [S][SUM]
/TITLES
    TITLE='PERSONAL CALIFICADO Y NO CALIFICADO'
    CAPTION='BDD1_G_AMB_GAD_2018'.

* Tabla 3 por provincia.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno1_2 v1_2_4 v1_2_7 v1_2_8 DISPLAY=LABEL
  /TABLE codigo_gobierno1_2 [C] BY v1_2_4 [S][SUM, COLPCT.SUM PCT40.1] + v1_2_7 [S][SUM, COLPCT.SUM 
    PCT40.1] + v1_2_8 [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno1_2 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
/TITLES
    TITLE='PERSONAL CALIFICADO Y NO CALIFICADO POR PROVINCIA'
    CAPTION='BDD1_G_AMB_GAD_2018'. 

* Tabla 4 por provincia.

DATASET ACTIVATE BDD2_G_AMB_GAD_2018.

CTABLES
  /VLABELS VARIABLES=v1_4 DISPLAY=LABEL
  /TABLE v1_4 [C][COUNT F40.0, COLPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=v1_4 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
/TITLES
    TITLE='GAD PROVINCIALES ACREDITADOS COMO AUTORIDAD AMBIENTAL DE APLICACIN  RESPONSABLE'
    CAPTION='BDD2_G_AMB_GAD_2018'.

* Tabla 5

CTABLES
  /VLABELS VARIABLES=v1_6_a v1_6_b v1_6_c DISPLAY=LABEL
  /TABLE v1_6_a [C][COUNT F40.0] + v1_6_b [C][COUNT F40.0] + v1_6_c [C][COUNT F40.0]
  /CATEGORIES VARIABLES=v1_6_a v1_6_b v1_6_c ORDER=A KEY=VALUE EMPTY=INCLUDE
 /TITLES
    TITLE='NMERO DE GAD PROVINCIALES QUE EMITIERON PERMISOS AMBIENTALES '
    CAPTION='BDD2_G_AMB_GAD_2018'.

* Tabla 6.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno v1_6_a_numero v1_6_b_numero DISPLAY=LABEL
  /TABLE codigo_gobierno [C] BY v1_6_a_numero [S][SUM, ROWPCT.SUM PCT40.1] + v1_6_b_numero [S][SUM, 
    ROWPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
 /TITLES
    TITLE='  NMERO DE PERMISOS AMBIENTALES EMITIDOS POR LOS GAD PROVINCIALES A TRAVS DEL SUIA, SEGN PROVINCIA'
    CAPTION='BDD2_G_AMB_GAD_2018'.



* Tabla 7

CTABLES
  /VLABELS VARIABLES=codigo_gobierno v1_6_1_1_a_numero v1_6_1_1_b_numero v1_6_1_1_c_numero 
    v1_6_1_1_d_numero v1_6_1_1_e_numero v1_6_1_1_f_numero v1_6_1_1_g_numero v1_6_1_1_h_numero 
    v1_6_1_1_i_numero v1_6_1_1_j_numero 
    DISPLAY=LABEL
  /TABLE codigo_gobierno [C] BY v1_6_1_1_a_numero [S][SUM, COLPCT.SUM PCT40.1] + v1_6_1_1_b_numero 
    [S][SUM, COLPCT.SUM PCT40.1] + v1_6_1_1_c_numero [S][SUM, COLPCT.SUM PCT40.1] + v1_6_1_1_d_numero 
    [S][SUM, COLPCT.SUM PCT40.1] + v1_6_1_1_e_numero [S][SUM, COLPCT.SUM PCT40.1] + v1_6_1_1_f_numero 
    [S][SUM, COLPCT.SUM PCT40.1] + v1_6_1_1_g_numero [S][SUM, COLPCT.SUM PCT40.1] + v1_6_1_1_h_numero 
    [S][SUM, COLPCT.SUM PCT40.1] + v1_6_1_1_i_numero [S][SUM, COLPCT.SUM PCT40.1] + v1_6_1_1_j_numero 
    [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
 /TITLES
    TITLE=' NMERO CONTROLES Y/O SEGUIMIENTOS A LOS PERMISOS AMBIENTALES EN EL AO 2018, POR GAD PROVINCIAL' 
    CAPTION='BDD2_G_AMB_GAD_2018'.

* Tabla 8

CTABLES
  /VLABELS VARIABLES=codigo_gobierno v1_6_2_1_a_numero v1_6_2_1_b_numero v1_6_2_1_c_numero 
    v1_6_2_1_d_numero DISPLAY=LABEL
  /TABLE codigo_gobierno [C] BY v1_6_2_1_a_numero [S][SUM, COLPCT.SUM PCT40.1] + v1_6_2_1_b_numero 
    [S][SUM, COLPCT.SUM PCT40.1] + v1_6_2_1_c_numero [S][SUM, COLPCT.SUM PCT40.1] + v1_6_2_1_d_numero 
    [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
 /TITLES
    TITLE=' NMERO DE EVALUACIONES Y PRONUNCIAMIENTOS A DOCUMENTOS ADMINISTRATIVOS DE CONTROL Y SEGUIMIENTO AMBIENTAL EN EL AO 2018, POR GAD PROVINCIAL' 
    CAPTION='BDD2_G_AMB_GAD_2018'.

* Tabla 9

CTABLES
  /VLABELS VARIABLES=codigo_gobierno v1_7_1_a_numero v1_7_1_b_numero v1_7_1_c_numero 
    v1_7_1_d_numero DISPLAY=LABEL
  /TABLE codigo_gobierno [C] BY v1_7_1_a_numero [S][SUM, COLPCT.SUM PCT40.1] + v1_7_1_b_numero 
    [S][SUM, COLPCT.SUM PCT40.1] + v1_7_1_c_numero [S][SUM, COLPCT.SUM PCT40.1] + v1_7_1_d_numero 
    [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
 /TITLES
    TITLE=' NMERO DE DENUNCIAS AMBIENTALES EN EL AO 2018, POR GAD PROVINCIAL' 
    CAPTION='BDD2_G_AMB_GAD_2018'.


* Tabla 10.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno v1_9_1_a v1_9_1_b v1_9_1_c v1_9_1_d DISPLAY=LABEL
  /TABLE codigo_gobierno [C] BY v1_9_1_a [S][SUM, COLPCT.SUM PCT40.1] + v1_9_1_b [S][SUM, 
    COLPCT.SUM PCT40.1] + v1_9_1_c [S][SUM, COLPCT.SUM PCT40.1] + v1_9_1_d [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
 /TITLES
    TITLE=' NMERO DE VIVEROS POR GAD PROVINCIAL'
    CAPTION='BDD2_G_AMB_GAD_2018'.


* Tablas 11.
* REA PRIVADA.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_1_8 tipo_de_especie_finalidad1_8 v1_8_1_1_1 v1_8_2_1_1 
    si_no1_8 DISPLAY=LABEL
  /TABLE codigo_gobierno_1_8 [C] BY tipo_de_especie_finalidad1_8 [C] > v1_8_1_1_1 [S][SUM, 
    COLPCT.SUM PCT40.1] + tipo_de_especie_finalidad1_8 [C] > v1_8_2_1_1 [S][SUM, COLPCT.SUM PCT40.1] BY 
    si_no1_8 [C]
  /CATEGORIES VARIABLES=codigo_gobierno_1_8 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=tipo_de_especie_finalidad1_8 ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=si_no1_8 ORDER=A KEY=VALUE EMPTY=INCLUDE
 /TITLES
    TITLE='SUPERFICIE FORESTADA Y REFORESTADA CON ESPECIES NATIVAS, ADAPTADAS E INTRODUCIDAS - rea Privada'
    CAPTION='BDD1_G_AMB_GAD_2018'. 

* Tablas 11.
* REA PBLICA.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_1_8 tipo_de_especie_finalidad1_8 v1_8_1_2_1 v1_8_2_2_1 
    si_no1_8 DISPLAY=LABEL
  /TABLE codigo_gobierno_1_8 [C] BY tipo_de_especie_finalidad1_8 [C] > v1_8_1_2_1 [S][SUM, 
    COLPCT.SUM PCT40.1] + tipo_de_especie_finalidad1_8 [C] > v1_8_2_2_1 [S][SUM, COLPCT.SUM PCT40.1] BY 
    si_no1_8 [C]
  /CATEGORIES VARIABLES=codigo_gobierno_1_8 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=tipo_de_especie_finalidad1_8 ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=si_no1_8 ORDER=A KEY=VALUE EMPTY=INCLUDE
  /TITLES
    TITLE='SUPERFICIE FORESTADA Y REFORESTADA CON ESPECIES NATIVAS, ADAPTADAS E INTRODUCIDAS - rea Pblica'
    CAPTION='BDD1_G_AMB_GAD_2018'. 


* Tablas 12

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_1_9 vivero1_9 v1_9_4 DISPLAY=LABEL
  /TABLE codigo_gobierno_1_9 [C] BY vivero1_9 [C] > v1_9_4 [S][SUM, ROWPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_1_9 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=vivero1_9 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
 /TITLES
    TITLE='PRODUCCIN AL AO DE PLANTAS POR TIPO DE VIVERO'
    CAPTION='BDD1_G_AMB_GAD_2018'. 


* Tablas 13.
CTABLES
  /VLABELS VARIABLES=codigo_gobierno_1_10 v1_10_2 DISPLAY=LABEL
  /TABLE codigo_gobierno_1_10 [C] BY v1_10_2 [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_1_10 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
 /TITLES
    TITLE='SUPERFICIE AFECTADA POR INCENDIOS, SEGN PROVINCIAS'
    CAPTION='BDD1_G_AMB_GAD_2018'.

* Tablas 14.
CTABLES
  /VLABELS VARIABLES=entidades1_11 si_no_1_11 DISPLAY=LABEL
  /TABLE entidades1_11 [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] BY si_no_1_11 [C]
  /CATEGORIES VARIABLES=entidades1_11 ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=si_no_1_11 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
/TITLES
    TITLE='NMERO DE GAD QUE IMPULSARON MECANISMOS DE ARTICULACIN PARA PREVENCIN Y CONTROL DE INCENDIOS FORESTALES, SEGN ENTIDADES'
    CAPTION='BDD1_G_AMB_GAD_2018'.


* Tablas 15.

COMPUTE v1_12_numnormativa=codigo_gobierno_1_12  >= 1 <= 24.
EXECUTE.

CTABLES
  /VLABELS VARIABLES=v1_12_numnormativa_si_no DISPLAY=LABEL
  /TABLE v1_12_numnormativa_si_no [C][COUNT F40.0]
  /CATEGORIES VARIABLES=v1_12_numnormativa_si_no ORDER=A KEY=VALUE EMPTY=INCLUDE
/TITLES
    TITLE='GAD PROVINCIALES QUE EMITIERON INSTRUMENTOS DE PLANIFICACIN Y NORMATIVA LOCAL EN DEFENSA DE SUS RECURSOS NATURALES'
    CAPTION='BDD1_G_AMB_GAD_2018'.

* Tablas 16.
CTABLES
  /VLABELS VARIABLES=codigo_gobierno_1_12 v1_12_1 DISPLAY=LABEL
  /TABLE codigo_gobierno_1_12 [C][COUNT F40.0] BY v1_12_1 [C]
  /CATEGORIES VARIABLES=codigo_gobierno_1_12 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=v1_12_1 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
/TITLES
    TITLE='INSTRUMENTOS DE PLANIFICACIN Y NORMATIVA  LOCAL EMITIDOS EN DEFENSA DE LOS RECURSOS NATURALES, SEGN GAD PROVINCIAL'
    CAPTION='BDD1_G_AMB_GAD_2018'.


* Tablas 17.

COMPUTE v1_13_numgads=codigo_gobierno_1_13 >= 1 <= 24.
EXECUTE.


CTABLES
  /VLABELS VARIABLES=v1_13_numgad_si_no DISPLAY=LABEL
  /TABLE v1_13_numgad_si_no [C][COUNT F40.0]
  /CATEGORIES VARIABLES=v1_13_numgad_si_no ORDER=A KEY=VALUE EMPTY=INCLUDE
/TITLES
    TITLE='GAD PROVINCIALES QUE EJECUTARON PROYECTOS EN GESTIN AMBIENTAL'
    CAPTION='BDD1_G_AMB_GAD_2018'.


* Tablas 18.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_1_13 v1_13_9_gob v1_13_9_gad v1_13_9_coop v1_13_9_otro 
    DISPLAY=LABEL
  /TABLE codigo_gobierno_1_13 [C] BY v1_13_9_gob [S][SUM] + v1_13_9_gad [S][SUM] + v1_13_9_coop 
    [S][SUM] + v1_13_9_otro [S][SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_1_13 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
/TITLES
    TITLE='MONTO POR FUENTES DE FINANCIAMIENTO PARA PROYECTOS DE GESTIN AMBIENTAL, SEGN GAD PROVINCIAL'
    CAPTION='BDD1_G_AMB_GAD_2018'.


* Tabla 19.

COMPUTE v1_13_proyects=codigo_gobierno_1_13  >= 1 <= 24.
FILTER BY v1_13_proyects.
EXECUTE.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_1_13 v1_13_proyects v1_13_7 DISPLAY=LABEL
  /TABLE codigo_gobierno_1_13 [C] BY v1_13_proyects [C][COUNT F40.0] + v1_13_7 [S][SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_1_13 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=v1_13_proyects ORDER=A KEY=VALUE EMPTY=EXCLUDE
/TITLES
    TITLE='PROYECTOS E INVERSIN  EN GESTIN AMBIENTAL SEGN GAD PROVINCIALES'
    CAPTION='BDD1_G_AMB_GAD_2018'.

FILTER OFF.

* Tabla 20

COMPUTE v1_14_numgads=codigo_gobierno_1_14 >= 1 <= 24.
EXECUTE.


CTABLES
  /VLABELS VARIABLES=v1_14_numgad_si_no DISPLAY=LABEL
  /TABLE v1_14_numgad_si_no [C][COUNT F40.0]
  /CATEGORIES VARIABLES=v1_14_numgad_si_no ORDER=A KEY=VALUE EMPTY=INCLUDE
/TITLES
    TITLE='GAD PROVINCIALES QUE EJECUTARON PROYECTOS REFERENTES AL CAMBIO CLIMTICO'
    CAPTION='BDD1_G_AMB_GAD_2018'.


* Tabla 21

COMPUTE v1_14_proyects=codigo_gobierno_1_14 >= 1 <= 24.
EXECUTE.


CTABLES
  /VLABELS VARIABLES=codigo_gobierno_1_14 v1_14_proyects v1_14_7 DISPLAY=LABEL
  /TABLE codigo_gobierno_1_14 [C] BY v1_14_proyects [C][COUNT F40.0] + v1_14_7 [S][SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_1_14 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=v1_14_proyects ORDER=A KEY=VALUE EMPTY=INCLUDE
/TITLES
    TITLE='PROYECTOS E INVERSIN EN CAMBIO CLIMTICO, SEGN GAD PROVINCIALES'
    CAPTION='BDD1_G_AMB_GAD_2018'.

* Tabla 22

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_1_14 v1_14_9_gob v1_14_9_gad v1_14_9_coop v1_14_9_otro 
    DISPLAY=LABEL
  /TABLE codigo_gobierno_1_14 BY v1_14_9_gob [SUM] + v1_14_9_gad [SUM] + v1_14_9_coop [SUM] + 
    v1_14_9_otro [SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_1_14 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
/TITLES
    TITLE='MONTO POR FUENTES DE FINANCIAMIENTO PARA PROYECTOS REFERENTES A CAMBIO CLIMTICO , SEGN GAD PROVINCIAL'
    CAPTION='BDD1_G_AMB_GAD_2018'.

* Tabla 23.
CTABLES
  /VLABELS VARIABLES=v1_15_a v1_15_b v1_15_c v1_15_d v1_15_e v1_15_f v1_15_g v1_15_h v1_15_i 
    v1_15_j 
    DISPLAY=LABEL
  /TABLE v1_15_a [C][COUNT F40.0, COLPCT.COUNT PCT40.1] + v1_15_b [C][COUNT F40.0, COLPCT.COUNT 
    PCT40.1] + v1_15_c [C][COUNT F40.0, COLPCT.COUNT PCT40.1] + v1_15_d [C][COUNT F40.0, COLPCT.COUNT 
    PCT40.1] + v1_15_e [C][COUNT F40.0, COLPCT.COUNT PCT40.1] + v1_15_f [C][COUNT F40.0, COLPCT.COUNT 
    PCT40.1] + v1_15_g [C][COUNT F40.0, COLPCT.COUNT PCT40.1] + v1_15_h [C][COUNT F40.0, COLPCT.COUNT 
    PCT40.1] + v1_15_i [C][COUNT F40.0, COLPCT.COUNT PCT40.1] + v1_15_j [C][COUNT F40.0, COLPCT.COUNT 
    PCT40.1]
  /CATEGORIES VARIABLES=v1_15_a v1_15_b v1_15_c v1_15_d v1_15_e v1_15_f v1_15_g v1_15_h v1_15_i 
    v1_15_j ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
/TITLES
    TITLE='AFECTACIONES AMBIENTALES EN PROVINCIAS, SEGN TIPO'
    CAPTION='BDD2_G_AMB_GAD_2018'.

* Tabla 24.
CTABLES
  /VLABELS VARIABLES=v1_15_3 DISPLAY=LABEL
  /TABLE v1_15_3 [C][COUNT F40.0, COLPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=v1_15_3 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
/TITLES
    TITLE='PRINCIPAL AFECTACIN DE LOS GAD PROVINCIALES'
    CAPTION='BDD2_G_AMB_GAD_2018'.

* Tabla 25.
CTABLES
  /VLABELS VARIABLES=v1_16_a v1_16_b v1_16_c DISPLAY=LABEL
  /TABLE v1_16_a [C][COUNT F40.0, COLPCT.COUNT PCT40.1] + v1_16_b [C][COUNT F40.0, COLPCT.COUNT 
    PCT40.1] + v1_16_c [C][COUNT F40.0, COLPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=v1_16_a v1_16_b v1_16_c ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=AFTER
/TITLES
    TITLE='NMERO DE GAD PROVINCIALES QUE ESTABLECIERON LNEAS DE TRABAJO  PARA EL CONTROL DEL TRFICO Y VENTA ILEGAL SEGN  RECURSOS NATURALES'
    CAPTION='BDD2_G_AMB_GAD_2018'.

********************************************************************************************************************************************************************************************************

* CAPITULO II- FOMENTO Y DESARROLLO PRODUCTIVO 2018

* Tabla 26.

CTABLES
  /VLABELS VARIABLES=v2_1_a v2_1_b v2_1_c v2_1_d v2_1_e DISPLAY=LABEL
  /TABLE v2_1_a [C][COUNT F40.0] + v2_1_b [C][COUNT F40.0] + v2_1_c [C][COUNT F40.0] + v2_1_d 
    [C][COUNT F40.0] + v2_1_e [C][COUNT F40.0]
  /CATEGORIES VARIABLES=v2_1_a v2_1_b v2_1_c v2_1_d v2_1_e ORDER=A KEY=VALUE EMPTY=INCLUDE
/TITLES
    TITLE='ESTRUCTURA ORGANIZACIONAL DE LOS GAD PROVINCIALES'
    CAPTION='BDD_FO_PRO_GAD_2018'.


* Tabla 27.

CTABLES
  /VLABELS VARIABLES=v2_2_1 v2_2_2 DISPLAY=LABEL
  /TABLE v2_2_1 [S][SUM, TABLEPCT.SUM PCT40.1] + v2_2_2 [S][SUM, TABLEPCT.SUM PCT40.1]
/TITLES
    TITLE='PERSONAL CON EL QUE CONT  LA COMPETENCIA DE FOMENTO Y DESARROLLO PRODUCTIVO'
    CAPTION='BDD_FO_PRO_GAD_2018'.

* Tabla 28.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_2_2 v2_2_1 v2_2_2 DISPLAY=LABEL
  /TABLE codigo_gobierno_2_2 [C] BY v2_2_1 [S][SUM, COLPCT.SUM PCT40.1] +  v2_2_2 [S][SUM, COLPCT.SUM 
    PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_2_2 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
/TITLES
    TITLE='PERSONAL CON EL QUE CONT  LA COMPETENCIA DE FOMENTO Y DESARROLLO PRODUCTIVO SEGN GAD PROVINCIAL '
    CAPTION='BDD_FO_PRO_GAD_2018'.

* Tabla 29.

CTABLES
  /VLABELS VARIABLES=v2_2_4 v2_2_7 v2_2_8 DISPLAY=LABEL
  /TABLE v2_2_4 [S][SUM] + v2_2_7 [S][SUM] + v2_2_8 [S][SUM]
/TITLES
    TITLE='PERSONAL CALIFICADO Y NO CALIFICADO'
    CAPTION='BDD_FO_PRO_GAD_2018'.

* Tabla 30.
CTABLES
  /VLABELS VARIABLES=codigo_gobierno_2_2 v2_2_4 v2_2_7 v2_2_8 DISPLAY=LABEL
  /TABLE codigo_gobierno_2_2 [C] BY v2_2_4 [S][SUM, COLPCT.SUM PCT40.1] + v2_2_7 [S][SUM, COLPCT.SUM 
    PCT40.1] + v2_2_8 [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_2_2 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
/TITLES
    TITLE='PERSONAL CALIFICADO Y NO CALIFICADO POR PROVINCIA'
    CAPTION='BDD_FO_PRO_GAD_2018'.


* Tabla 31

COMPUTE v2_3_normativa=codigo_gobierno_2_3  >= 1 <= 24.
EXECUTE.

CTABLES
  /VLABELS VARIABLES=v2_3_normativa v2_3_normativa_si_no DISPLAY=LABEL
  /TABLE v2_3_normativa [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] BY BY v2_3_normativa_si_no [C]
  /CATEGORIES VARIABLES=v2_3_normativa v2_3_normativa_si_no ORDER=A KEY=VALUE EMPTY=INCLUDE
/TITLES
    TITLE='GAD PROVINCIALES QUE EMITIERON INSTRUMENTOS DE PLANIFICACIN Y NORMATIVA LOCAL A FAVOR DE COOPERACIN INTERNACIONAL'
    CAPTION='BDD_FO_PRO_GAD_2018'.


* Tabla 32

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_2_3 v2_3_1 DISPLAY=LABEL
  /TABLE codigo_gobierno_2_3 [C][COUNT F40.0] BY v2_3_1 [C]
  /CATEGORIES VARIABLES=codigo_gobierno_2_3 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=v2_3_1 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
/TITLES
    TITLE='NMERO DE INSTRUMENTOS EMITIDOS POR LOS GAD PROVINCIALES PARA EL DESARROLLO PRODUCTIVO, POR NORMATIVA'
    CAPTION='BDD_FO_PRO_GAD_2018'.

* Tabla 33

CTABLES
  /VLABELS VARIABLES=instituciones_2_4 si_no_2_4 DISPLAY=LABEL
  /TABLE instituciones_2_4 [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] BY si_no_2_4 [C]
  /CATEGORIES VARIABLES=instituciones_2_4 si_no_2_4 ORDER=A KEY=VALUE EMPTY=INCLUDE
/TITLES
    TITLE='GAD PROVINCIALES QUE IMPULSARON MECANISMOS DE ARTICULACIN A FAVOR DEL FOMENTO  Y DESARROLLO PRODUCTIVO, SEGN TIPO DE INSTITUCIONES'
    CAPTION='BDD_FO_PRO_GAD_2018'.

* Tabla 34

CTABLES
  /VLABELS VARIABLES=instituciones_2_4 v2_4_1 v2_4_2 v2_4_3 si_no_2_4 DISPLAY=LABEL
  /TABLE instituciones_2_4 [C][COUNT F40.0] BY v2_4_1 [C] + v2_4_2 [C] + v2_4_3 [C] BY si_no_2_4 [C]    
  /CATEGORIES VARIABLES=instituciones_2_4 v2_4_1 v2_4_2 v2_4_3 si_no_2_4 ORDER=A KEY=VALUE 
    EMPTY=INCLUDE
/TITLES
    TITLE='TIPOS DE MECANISMOS CON LOS QUE LOS  GAD PROVINCIALES SE ARTICULARON CON LAS INSTITUCIONES'
    CAPTION='BDD_FO_PRO_GAD_2018'.


* Tabla 35

COMPUTE v2_5_proyects=codigo_gobierno_2_5  >= 1 <= 24.
FILTER BY v2_5_proyects.
EXECUTE.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_2_5 v2_5_proyects v2_5_8 DISPLAY=LABEL
  /TABLE codigo_gobierno_2_5 [C] BY v2_5_proyects [C][COUNT F40.0] + v2_5_8 [S][SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_2_5 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=v2_5_proyects ORDER=A KEY=VALUE EMPTY=EXCLUDE
/TITLES
    TITLE='NMERO DE PROYECTOS E INVERSIN  EN  FOMENTO Y DESARROLLO PRODUCTIVO, SEGN GAD PROVINCIALES'
    CAPTION='BDD_FO_PRO_GAD_2018'.

FILTER OFF.


* Tabla 36

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_2_5 v2_5_10_gob v2_5_10_gad v2_5_10_coop v2_5_10_otro
    DISPLAY=LABEL
  /TABLE codigo_gobierno_2_5 BY v2_5_10_gob [SUM] + v2_5_10_gad [SUM] + v2_5_10_coop [SUM] + 
   v2_5_10_otro [SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_2_5 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
/TITLES
    TITLE='MONTO POR FUENTES DE FINANCIAMIENTO PARA PROYECTOS DE FOMENTO Y DESARROLLO PRODUCTIVO , SEGN GAD PROVINCIAL'
    CAPTION='BDD_FO_PRO_GAD_2018'.

* Tabla 37

CTABLES
  /VLABELS VARIABLES=infraestr_2_6 infra_agri_2_6 infra_acua_2_6 infra_gan_2_6 infra_pes_2_6 
    infra_tur_2_6 infra_ind_2_6 infra_agroind_2_6 infra_econ_solid_2_6 infra_agropecu_2_6 
    DISPLAY=LABEL
  /TABLE infraestr_2_6 [C] BY infra_agri_2_6 [S][SUM] + infra_acua_2_6 [S][SUM] + infra_gan_2_6 
    [S][SUM] + infra_pes_2_6 [S][SUM] + infra_tur_2_6 [S][SUM] + infra_ind_2_6 [S][SUM] + 
    infra_agroind_2_6 [S][SUM] + infra_econ_solid_2_6 [S][SUM] + infra_agropecu_2_6 [S][SUM]
  /CATEGORIES VARIABLES=infraestr_2_6 ORDER=A KEY=VALUE EMPTY=INCLUDE
/TITLES
    TITLE='NMERO DE CENTROS,  POR SECTORES PRODUCTIVOS'
    CAPTION='BDD_FO_PRO_GAD_2018'.

* Tabla 38

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_2_6 infra_agri_2_6 infra_acua_2_6 infra_gan_2_6 infra_pes_2_6 
    infra_tur_2_6 infra_ind_2_6 infra_agroind_2_6 infra_econ_solid_2_6 infra_agropecu_2_6 
    DISPLAY=LABEL
  /TABLE codigo_gobierno_2_6 [C] BY infra_agri_2_6 [S][SUM] + infra_acua_2_6 [S][SUM] + 
    infra_gan_2_6 [S][SUM] + infra_pes_2_6 [S][SUM] + infra_tur_2_6 [S][SUM] + infra_ind_2_6 [S][SUM] + 
    infra_agroind_2_6 [S][SUM] + infra_econ_solid_2_6 [S][SUM] + infra_agropecu_2_6 [S][SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_2_6 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
/TITLES
    TITLE='NMERO DE CENTROS  PARA EL DESARROLLO PRODUCTIVO, SEGN PROVINCIAS'
    CAPTION='BDD_FO_PRO_GAD_2018'.


******************************************************************************************************************************************************************************
******************************************************************************************************************************************************************************

* CAPITULO III- RIEGO Y DRENAJE- 2018

* Encoding: UTF-8.

* SINTAXIS DE RIEGO Y DRENAJE
* CENSO DE INFORMACIN AMBIENTAL ECONMICA EN GOBIERNOS AUTNOMOS DESCENTRALIZADOS PROVINCIALES AO 2018.

* TABLA 39. ESTRUCTURA ORGANIZACIONAL DE LOS GAD PROVINCIALES PARA LA GESTIN DE LA COMPETENCIA DE RIEGO Y DRENAJE.
* Abrir base BDD2_RIEGO_GAD_2018.sav.

CTABLES
  /VLABELS VARIABLES=v3_1_a v3_1_b v3_1_c v3_1_d v3_1_e DISPLAY=LABEL
  /TABLE v3_1_a [COUNT F40.0] + v3_1_b [COUNT F40.0] + v3_1_c [COUNT F40.0] + v3_1_d [COUNT F40.0] + v3_1_e [COUNT F40.0]
  /CATEGORIES VARIABLES=v3_1_a v3_1_b v3_1_c v3_1_d v3_1_e [1] EMPTY=INCLUDE
  /TITLES
    TITLE='ESTRUCTURA ORGANIZACIONAL DE LOS GAD PROVINCIALES PARA LA GESTIN DE LA COMPETENCIA DE RIEGO Y DRENAJE'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.


* TABLA 40. PERSONAL CON EL QUE CONT LA COMPETENCIA DE RIEGO Y DRENAJE, POR PROVINCIAS Y SEGN RGIMEN LABORAL.
* Abrir base BDD1_RIEGO_GAD_2018.sav.

* Recodificacin y renombramiento de la variable gen_3_2 por sexo_3_2.

RENAME VARIABLES (gen_3_2 = sexo_3_2).
VARIABLE LABELS sexo_3_2 "3.2 Sexo".

IF (sexo_3_2 = "MASCULINO") sexo_3_2 = "Hombre".
IF (sexo_3_2 = "hombre") sexo_3_2 = "Hombre".
IF (sexo_3_2 = "FEMENINO") sexo_3_2 = "Mujer".
IF (sexo_3_2 = "mujer") sexo_3_2 = "Mujer".
FREQUENCIES sexo_3_2.

VARIABLE LEVEL codigo_gobierno_3_2 (NOMINAL).

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_2 regi_3_2 DISPLAY=LABEL
  /TABLE codigo_gobierno_3_2 [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] BY regi_3_2 [C]
  /CATEGORIES VARIABLES=codigo_gobierno_3_2 ORDER=A KEY=VALUE EMPTY=INCLUDE
  /CATEGORIES VARIABLES=regi_3_2 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='PERSONAL CON EL QUE CONT LA COMPETENCIA DE RIEGO Y DRENAJE, POR PROVINCIAS Y SEGN RGIMEN LABORAL'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.


* TABLA 41. NUEVA. PERSONAL FORMADO Y/O CAPACITADO PARA MEJORA DE LA COMPETENCIA DE RIEGO Y DRENAJE, POR PROVINCIA Y SEGN TIPO DE FORMACIN.
* Abrir base BDD2_RIEGO_GAD_2018.sav.

VARIABLE LEVEL codigo_gobierno (NOMINAL).

VARIABLE LEVEL v3_3_1_a v3_3_1_b v3_3_1_c v3_3_1_d v3_3_1_e v3_3_1_f (SCALE).

CTABLES
  /VLABELS VARIABLES=codigo_gobierno v3_3_1_a v3_3_1_b v3_3_1_c v3_3_1_d v3_3_1_e v3_3_1_f DISPLAY=LABEL
  /TABLE codigo_gobierno [C] BY v3_3_1_a [S][SUM] + v3_3_1_b [S][SUM] + v3_3_1_c [S][SUM] + v3_3_1_d [S][SUM] +
     v3_3_1_e [SUM] + v3_3_1_f [S][SUM]
  /CATEGORIES VARIABLES=codigo_gobierno ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='PERSONAL FORMADO Y/O CAPACITADO PARA MEJORA DE LA COMPETENCIA DE RIEGO Y DRENAJE, POR PROVINCIA Y SEGN TIPO DE FORMACIN'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.


* TABLA 42. GAD PROVINCIALES  CON EQUIPOS Y HERRAMIENTAS DE GESTIN PARA RIEGO Y DRENAJE.
* Abrir base BDD2_RIEGO_GAD_2018.sav.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno v3_4_a v3_4_b v3_4_c v3_4_d v3_4_e v3_4_f v3_4_g v3_4_h v3_4_i DISPLAY=LABEL
  /TABLE codigo_gobierno [C][COUNT F40.0] BY v3_4_a + v3_4_b + v3_4_c + v3_4_d + v3_4_e + v3_4_f + v3_4_g + v3_4_h + v3_4_i
  /CATEGORIES VARIABLES=codigo_gobierno ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=v3_4_a v3_4_b v3_4_c v3_4_d v3_4_e v3_4_f v3_4_g v3_4_h v3_4_i [1] EMPTY=INCLUDE
  /TITLES
    TITLE='GAD PROVINCIALES  CON EQUIPOS Y HERRAMIENTAS DE GESTIN PARA RIEGO Y DRENAJE'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.


* TABLA 43. NMERO DE GADP POR ETAPAS DEL PLAN PROVINCIAL DE RIEGO Y DRENAJE, POR PROVINCIA Y SEGN ETAPA DEL PLAN DE RIEGO Y DRENAJE.
* Abrir base BDD2_RIEGO_GAD_2018.sav.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno v3_5 DISPLAY=LABEL
  /TABLE codigo_gobierno [C][COUNT F40.0] BY v3_5
  /CATEGORIES VARIABLES=codigo_gobierno ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=v3_5 ORDER=A KEY=VALUE EMPTY=INCLUDE
  /TITLES
    TITLE='RECUENTO DE GADP POR ETAPAS DEL PLAN PROVINCIAL DE RIEGO Y DRENAJE, POR PROVINCIA Y SEGN ETAPA DEL PLAN DE RIEGO Y DRENAJE'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.


* TABLA 44. PRESUPUESTO, INVERSIN, AOS DE EJECUCIN Y PORCENTAJE DE EJECUCIN AL 2018 DEL PLAN DE RIEGO Y DRENAJE, POR PROVINCIA.
* Abrir base BDD2_RIEGO_GAD_2018.sav.

ALTER TYPE v3_6_a_presupuesto (F12.2) v3_6_b_inversion (F10.2).

VARIABLE LEVEL v3_6_a_presupuesto v3_6_b_inversion (SCALE).
VARIABLE LEVEL v3_6_c_aos_ejecucion v3_6_c_porcentaje_ejecucion (SCALE).

CTABLES
  /VLABELS VARIABLES=codigo_gobierno v3_6_a_presupuesto v3_6_b_inversion v3_6_c_aos_ejecucion v3_6_c_porcentaje_ejecucion DISPLAY=LABEL
  /TABLE codigo_gobierno [C] BY v3_6_a_presupuesto [S][SUM] + v3_6_b_inversion [S][SUM] +
    v3_6_c_aos_ejecucion [S][MEAN] + v3_6_c_porcentaje_ejecucion [S][MEAN]
  /CATEGORIES VARIABLES=codigo_gobierno ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='PRESUPUESTO, INVERSIN, AOS DE EJECUCIN Y PORCENTAJE DE EJECUCIN AL 2018 DEL PLAN DE RIEGO Y DRENAJE, POR PROVINCIA'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.


* TABLA 45. ACTORES QUE INTERVINIERON EN EL AO 2018 EN LA CONSTRUCCIN DEL PLAN DE RIEGO Y DRENAJE. 
* Abrir base BDD2_RIEGO_GAD_2018.sav.

CTABLES
  /VLABELS VARIABLES=v3_7_a v3_7_b v3_7_c v3_7_d v3_7_e v3_7_f DISPLAY=LABEL
  /TABLE BY v3_7_a [C][COUNT F40.0] + v3_7_b [C][COUNT F40.0] + v3_7_c [C][COUNT F40.0] + v3_7_d
    [C][COUNT F40.0] + v3_7_e [C][COUNT F40.0] + v3_7_f [C][COUNT F40.0]
  /CATEGORIES VARIABLES=v3_7_a [1, 2, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
  /CATEGORIES VARIABLES=v3_7_b [1, 2, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
  /CATEGORIES VARIABLES=v3_7_c [1, 2, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
  /CATEGORIES VARIABLES=v3_7_d [1, 2, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
  /CATEGORIES VARIABLES=v3_7_e [1, 2, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
  /CATEGORIES VARIABLES=v3_7_f [1, 2, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='PRESUPUESTO, INVERSIN, AOS DE EJECUCIN Y PORCENTAJE DE EJECUCIN AL 2018 DEL PLAN DE RIEGO Y DRENAJE, POR PROVINCIA'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.


* TABLA 46. SISTEMAS DE RIEGO PUBLICOS (ADMINISTRADOS POR EL GADP), SUPERFICIE CUBIERTA Y EFECTIVAMENTE REGADA, POR PROVINCIA.
* Abrir base BDD1_RIEGO_GAD_2018.sav.

ALTER TYPE v3_8_3 v3_8_4 v3_8_5 v3_8_6_aspersion v3_8_6_micro_aspersion v3_8_6_goteo (F7.2).

VARIABLE LEVEL v3_8_1 v3_8_2 v3_8_3 v3_8_4 v3_8_5 v3_8_6_aspersion v3_8_6_micro_aspersion v3_8_6_goteo (SCALE).
VARIABLE LEVEL codigo_gobierno_3_8 (NOMINAL).

COMPUTE Filtro_A = (modelo_gestion_3_8 = "a").
FILTER BY Filtro_A.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_8 v3_8_1 v3_8_2 v3_8_3 v3_8_4 v3_8_5 v3_8_6_aspersion v3_8_6_micro_aspersion v3_8_6_goteo DISPLAY=LABEL
  /TABLE codigo_gobierno_3_8 [C] BY v3_8_1 [S][SUM, COLPCT.SUM PCT40.1] + v3_8_2 [S][SUM, COLPCT.SUM PCT40.1] + v3_8_3 [S][SUM, COLPCT.SUM PCT40.1]
    + v3_8_4 [S][SUM, COLPCT.SUM PCT40.1] + v3_8_5 [S][SUM, COLPCT.SUM PCT40.1] + v3_8_6_aspersion [S][SUM, COLPCT.SUM PCT40.1]
    + v3_8_6_micro_aspersion [S][SUM, COLPCT.SUM PCT40.1] + v3_8_6_goteo [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_3_8 EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='SISTEMAS DE RIEGO PUBLICOS (ADMINISTRADOS POR EL GADP), SUPERFICIE CUBIERTA Y EFECTIVAMENTE REGADA, POR PROVINCIA.'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 47. SISTEMAS DE RIEGO PUBLICOS (ADMINISTRADOS POR LOS USUARIOS), SUPERFICIE CUBIERTA Y EFECTIVAMENTE REGADA, POR PROVINCIA.
* Abrir base BDD1_RIEGO_GAD_2018.sav.

COMPUTE Filtro_B = (modelo_gestion_3_8 = "b").
FILTER BY Filtro_B.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_8 v3_8_1 v3_8_2 v3_8_3 v3_8_4 v3_8_5 v3_8_6_aspersion v3_8_6_micro_aspersion v3_8_6_goteo DISPLAY=LABEL
  /TABLE codigo_gobierno_3_8 [C] BY v3_8_1 [S][SUM, COLPCT.SUM PCT40.1] + v3_8_2 [S][SUM, COLPCT.SUM PCT40.1] + v3_8_3 [S][SUM, COLPCT.SUM PCT40.1]
    + v3_8_4 [S][SUM, COLPCT.SUM PCT40.1] + v3_8_5 [S][SUM, COLPCT.SUM PCT40.1] + v3_8_6_aspersion [S][SUM, COLPCT.SUM PCT40.1]
    + v3_8_6_micro_aspersion [S][SUM, COLPCT.SUM PCT40.1] + v3_8_6_goteo [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_3_8 EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='SISTEMAS DE RIEGO PUBLICOS (ADMINISTRADOS POR LOS USUARIOS), SUPERFICIE CUBIERTA Y EFECTIVAMENTE REGADA, POR PROVINCIA.'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 48. SISTEMAS DE RIEGO COMUNITARIO (ADMINISTRADOS POR LOS USUARIOS), SUPERFICIE CUBIERTA Y EFECTIVAMENTE REGADA, POR PROVINCIA.
* Abrir base BDD1_RIEGO_GAD_2018.sav.

COMPUTE Filtro_C = (modelo_gestion_3_8 = "c").
FILTER BY Filtro_C.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_8 v3_8_1 v3_8_2 v3_8_3 v3_8_4 v3_8_5 v3_8_6_aspersion v3_8_6_micro_aspersion v3_8_6_goteo DISPLAY=LABEL
  /TABLE codigo_gobierno_3_8 [C] BY v3_8_1 [S][SUM, COLPCT.SUM PCT40.1] + v3_8_2 [S][SUM, COLPCT.SUM PCT40.1] + v3_8_3 [S][SUM, COLPCT.SUM PCT40.1]
    + v3_8_4 [S][SUM, COLPCT.SUM PCT40.1] + v3_8_5 [S][SUM, COLPCT.SUM PCT40.1] + v3_8_6_aspersion [S][SUM, COLPCT.SUM PCT40.1]
    + v3_8_6_micro_aspersion [S][SUM, COLPCT.SUM PCT40.1] + v3_8_6_goteo [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_3_8 EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='SISTEMAS DE RIEGO COMUNITARIO (ADMINISTRADOS POR LOS USUARIOS), SUPERFICIE CUBIERTA Y EFECTIVAMENTE REGADA, POR PROVINCIA.'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 49. SISTEMAS DE RIEGO PRIVADOS, SUPERFICIE CUBIERTA Y EFECTIVAMENTE REGADA, POR PROVINCIA.
* Abrir base BDD1_RIEGO_GAD_2018.sav.

COMPUTE Filtro_D = (modelo_gestion_3_8 = "d").
FILTER BY Filtro_D.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_8 v3_8_1 v3_8_2 v3_8_3 v3_8_4 v3_8_5 v3_8_6_aspersion v3_8_6_micro_aspersion v3_8_6_goteo DISPLAY=LABEL
  /TABLE codigo_gobierno_3_8 [C] BY v3_8_1 [S][SUM, COLPCT.SUM PCT40.1] + v3_8_2 [S][SUM, COLPCT.SUM PCT40.1] + v3_8_3 [S][SUM, COLPCT.SUM PCT40.1]
    + v3_8_4 [S][SUM, COLPCT.SUM PCT40.1] + v3_8_5 [S][SUM, COLPCT.SUM PCT40.1] + v3_8_6_aspersion [S][SUM, COLPCT.SUM PCT40.1]
    + v3_8_6_micro_aspersion [S][SUM, COLPCT.SUM PCT40.1] + v3_8_6_goteo [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_3_8 EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='SISTEMAS DE RIEGO PRIVADOS, SUPERFICIE CUBIERTA Y EFECTIVAMENTE REGADA, POR PROVINCIA.'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.

DELETE VARIABLES Filtro_A Filtro_B Filtro_C Filtro_D.


* TABLA 50. PROYECTOS DE ESTUDIOS DE FACTIBILIDAD DE SISTEMAS DE RIEGO, INVERSIN, BENEFICIARIOS, AREA REGADA Y BENEFICIARIOS, POR PROVINCIA.

ALTER TYPE v3_10_2 (F9.2).
ALTER TYPE v3_10_5 (F6.2).

VARIABLE LEVEL codigo_gobierno_3_10 (NOMINAL).

IF (numero_3_10 = 0 & v3_10_2 = 0) v3_10_2 = $SYSMIS.
IF (numero_3_10 = 0 & v3_10_3 = 0) v3_10_3 = $SYSMIS.
IF (numero_3_10 = 0 & v3_10_4 = 0) v3_10_4 = $SYSMIS.
IF (numero_3_10 = 0 & v3_10_5 = 0) v3_10_5 = $SYSMIS.
EXECUTE.

VARIABLE LEVEL numero_3_10 (SCALE).
VARIABLE LEVEL v3_10_2 v3_10_3 v3_10_4 v3_10_5 (SCALE).

COMPUTE Filtro_A = (tipo_3_10 = "a").
FILTER BY Filtro_A.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_10 numero_3_10 v3_10_2 v3_10_3 v3_10_4 v3_10_5 DISPLAY=LABEL
  /TABLE codigo_gobierno_3_10 [C] BY numero_3_10 [S][SUM, COLPCT.SUM PCT40.1] + v3_10_2 [S][SUM, COLPCT.SUM PCT40.1]
   + v3_10_3 [S][SUM, COLPCT.SUM PCT40.1] + v3_10_4 [S][SUM, COLPCT.SUM PCT40.1] + v3_10_5 [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_3_10 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='PROYECTOS DE ESTUDIOS DE FACTIBILIDAD DE SISTEMAS DE RIEGO, INVERSIN, BENEFICIARIOS, AREA REGADA Y BENEFICIARIOS, POR PROVINCIA'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 51.MONTO DE FINANCIAMIENTO DE PROYECTOS DE ESTUDIOS DE FACTIBILIDAD DE SISTEMAS DE RIEGO  POR FUENTE SEGN GAD PROVINCIALES . 

ALTER TYPE v3_10_7_gob v3_10_7_gadp v3_10_7_cooperante v3_10_7_usuarios v3_10_7_otro v3_10_7_total (F9.2).
VARIABLE LEVEL v3_10_7_gob v3_10_7_gadp v3_10_7_cooperante v3_10_7_usuarios v3_10_7_otro v3_10_7_total (SCALE).

FILTER BY Filtro_A.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_10 v3_10_7_gob v3_10_7_gadp v3_10_7_cooperante v3_10_7_usuarios v3_10_7_otro v3_10_7_total DISPLAY=LABEL
  /TABLE codigo_gobierno_3_10 [C] BY v3_10_7_gob [SUM] + v3_10_7_gadp [SUM] + v3_10_7_cooperante [SUM] + v3_10_7_usuarios [SUM]
  + v3_10_7_otro [SUM] + v3_10_7_total [SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_3_10 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='MONTO DE FINANCIAMIENTO DE PROYECTOS DE ESTUDIOS DE FACTIBILIDAD DE SISTEMAS DE RIEGO  POR FUENTE SEGN GAD PROVINCIALES'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 52. PROYECTOS DE NUEVOS SISTEMAS DE RIEGO, INVERSIN, BENEFICIARIOS, AREA REGADA Y BENEFICIARIOS, POR PROVINCIA.

COMPUTE Filtro_B = (tipo_3_10 = "b").
FILTER BY Filtro_B.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_10 numero_3_10 v3_10_2 v3_10_3 v3_10_4 v3_10_5 DISPLAY=LABEL
  /TABLE codigo_gobierno_3_10 [C] BY numero_3_10 [S][SUM, COLPCT.SUM PCT40.1] + v3_10_2 [S][SUM, COLPCT.SUM PCT40.1]
   + v3_10_3 [S][SUM, COLPCT.SUM PCT40.1] + v3_10_4 [S][SUM, COLPCT.SUM PCT40.1] + v3_10_5 [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_3_10 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='PROYECTOS DE NUEVOS SISTEMAS DE RIEGO, INVERSIN, BENEFICIARIOS, AREA REGADA Y BENEFICIARIOS, POR PROVINCIA'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 53.  MONTO DE FINANCIAMIENTO DE PROYECTOS DE NUEVOS  SISTEMAS DE RIEGO POR FUENTE SEGN GAD PROVINCIALES

FILTER BY Filtro_B.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_10 v3_10_7_gob v3_10_7_gadp v3_10_7_cooperante v3_10_7_usuarios v3_10_7_otro v3_10_7_total DISPLAY=LABEL
  /TABLE codigo_gobierno_3_10 [C] BY v3_10_7_gob [SUM] + v3_10_7_gadp [SUM] + v3_10_7_cooperante [SUM] + v3_10_7_usuarios [SUM]
  + v3_10_7_otro [SUM] + v3_10_7_total [SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_3_10 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE=' MONTO DE FINANCIAMIENTO DE PROYECTOS DE NUEVOS  SISTEMAS DE RIEGO POR FUENTE SEGN GAD PROVINCIALES'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 54. PROYECTOS DE REHABILITACIN DE SISTEMAS DE RIEGO, INVERSIN, BENEFICIARIOS, AREA REGADA Y BENEFICIARIOS, POR PROVINCIA.

COMPUTE Filtro_C = (tipo_3_10 = "c").
FILTER BY Filtro_C.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_10 numero_3_10 v3_10_2 v3_10_3 v3_10_4 v3_10_5 DISPLAY=LABEL
  /TABLE codigo_gobierno_3_10 [C] BY numero_3_10 [S][SUM, COLPCT.SUM PCT40.1] + v3_10_2 [S][SUM, COLPCT.SUM PCT40.1]
   + v3_10_3 [S][SUM, COLPCT.SUM PCT40.1] + v3_10_4 [S][SUM, COLPCT.SUM PCT40.1] + v3_10_5 [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_3_10 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='PROYECTOS DE REHABILITACIN DE SISTEMAS DE RIEGO, INVERSIN, BENEFICIARIOS, AREA REGADA Y BENEFICIARIOS, POR PROVINCIA'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 55. MONTO DE FINANCIAMIENTO DE PROYECTOS DE REHABILITACIN  SISTEMAS DE RIEGO  POR FUENTE SEGN GAD PROVINCIALES . 

FILTER BY Filtro_C.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_10 v3_10_7_gob v3_10_7_gadp v3_10_7_cooperante v3_10_7_usuarios v3_10_7_otro v3_10_7_total DISPLAY=LABEL
  /TABLE codigo_gobierno_3_10 [C] BY v3_10_7_gob [SUM] + v3_10_7_gadp [SUM] + v3_10_7_cooperante [SUM] + v3_10_7_usuarios [SUM]
  + v3_10_7_otro [SUM] + v3_10_7_total [SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_3_10 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='MONTO DE FINANCIAMIENTO DE PROYECTOS DE REHABILITACIN  SISTEMAS DE RIEGO  POR FUENTE SEGN GAD PROVINCIALES '
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 56. PROYECTOS DE TECNIFICACIN DEL RIEGO POR UNIDAD PRODUCTIVA, INVERSIN, BENEFICIARIOS, AREA REGADA Y BENEFICIARIOS, POR PROVINCIA.

COMPUTE Filtro_D = (tipo_3_10 = "d").
FILTER BY Filtro_D.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_10 numero_3_10 v3_10_2 v3_10_3 v3_10_4 v3_10_5 DISPLAY=LABEL
  /TABLE codigo_gobierno_3_10 [C] BY numero_3_10 [S][SUM, COLPCT.SUM PCT40.1] + v3_10_2 [S][SUM, COLPCT.SUM PCT40.1]
   + v3_10_3 [S][SUM, COLPCT.SUM PCT40.1] + v3_10_4 [S][SUM, COLPCT.SUM PCT40.1] + v3_10_5 [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_3_10 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='PROYECTOS DE TECNIFICACIN DEL RIEGO POR UNIDAD PRODUCTIVA, INVERSIN, BENEFICIARIOS, AREA REGADA Y BENEFICIARIOS, POR PROVINCIA'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 57. MONTOS DE FINANCIAMIENTO DE PROYECTOS DE TECNIFICACIN DEL RIEGO POR UNIDAD PRODUCTIVA, POR PROVINCIA Y SEGN FUENTE DE FINANCIAMIENTO. 

FILTER BY Filtro_D.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_10 v3_10_7_gob v3_10_7_gadp v3_10_7_cooperante v3_10_7_usuarios v3_10_7_otro v3_10_7_total DISPLAY=LABEL
  /TABLE codigo_gobierno_3_10 [C] BY v3_10_7_gob [SUM] + v3_10_7_gadp [SUM] + v3_10_7_cooperante [SUM] + v3_10_7_usuarios [SUM]
  + v3_10_7_otro [SUM] + v3_10_7_total [SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_3_10 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='MONTOS DE FINANCIAMIENTO DE PROYECTOS DE TECNIFICACIN DEL RIEGO POR UNIDAD PRODUCTIVA, POR PROVINCIA Y SEGN FUENTE DE FINANCIAMIENTO'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.

DELETE VARIABLES Filtro_A Filtro_B Filtro_C Filtro_D.


* TABLA 58. PROYECTOS DE ESTUDIOS DE FACTIBILIDAD DE SISTEMAS DE DRENAJE, POR PROVINCIA.

ALTER TYPE v3_11_2 (F9.2).
ALTER TYPE v3_11_5 (F6.2).

VARIABLE LEVEL codigo_gobierno_3_11 (NOMINAL).

IF (numero_3_11 = 0 & v3_11_2 = 0) v3_11_2 = $SYSMIS.
IF (numero_3_11 = 0 & v3_11_3 = 0) v3_11_3 = $SYSMIS.
IF (numero_3_11 = 0 & v3_11_4 = 0) v3_11_4 = $SYSMIS.
IF (numero_3_11 = 0 & v3_11_5 = 0) v3_11_5 = $SYSMIS.
EXECUTE.

VARIABLE LEVEL numero_3_11 (SCALE).
VARIABLE LEVEL v3_11_2 v3_11_3 v3_11_4 v3_11_5 (SCALE).

COMPUTE Filtro_A = (tipo_3_11 = "a").
FILTER BY Filtro_A.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_11 numero_3_11 v3_11_2 v3_11_3 v3_11_4 v3_11_5 DISPLAY=LABEL
  /TABLE codigo_gobierno_3_11 [C] BY numero_3_11 [S][SUM, COLPCT.SUM PCT40.1] + v3_11_2 [S][SUM, COLPCT.SUM PCT40.1]
   + v3_11_3 [S][SUM, COLPCT.SUM PCT40.1] + v3_11_4 [S][SUM, COLPCT.SUM PCT40.1] + v3_11_5 [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_3_11 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='PROYECTOS DE ESTUDIOS DE FACTIBILIDAD DE SISTEMAS DE DRENAJE, INVERSIN, BENEFICIARIOS, AREA REGADA Y BENEFICIARIOS, POR PROVINCIA'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 59. MONTOS DE FINANCIAMIENTO DE PROYECTOS DE ESTUDIOS DE FACTIBILIDAD DE SISTEMAS DE DRENAJE, POR PROVINCIA Y SEGN FUENTE DE FINANCIAMIENTO. 

ALTER TYPE v3_11_7_gob v3_11_7_gadp v3_11_7_cooperante v3_11_7_usuarios v3_11_7_otro v3_11_7_total (F9.2).
VARIABLE LEVEL v3_11_7_gob v3_11_7_gadp v3_11_7_cooperante v3_11_7_usuarios v3_11_7_otro v3_11_7_total (SCALE).

FILTER BY Filtro_A.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_11 v3_11_7_gob v3_11_7_gadp v3_11_7_cooperante v3_11_7_usuarios v3_11_7_otro v3_11_7_total DISPLAY=LABEL
  /TABLE codigo_gobierno_3_11 [C] BY v3_11_7_gob [SUM] + v3_11_7_gadp [SUM] + v3_11_7_cooperante [SUM] + v3_11_7_usuarios [SUM]
  + v3_11_7_otro [SUM] + v3_11_7_total [SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_3_11 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='MONTOS DE FINANCIAMIENTO DE PROYECTOS DE ESTUDIOS DE FACTIBILIDAD DE SISTEMAS DE DRENAJE, POR PROVINCIA Y SEGN FUENTE DE FINANCIAMIENTO'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 60. PROYECTOS DE NUEVOS SISTEMAS DE DRENAJE, INVERSIN, BENEFICIARIOS, AREA REGADA Y BENEFICIARIOS, POR PROVINCIA.

COMPUTE Filtro_B = (tipo_3_11 = "b").
FILTER BY Filtro_B.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_11 numero_3_11 v3_11_2 v3_11_3 v3_11_4 v3_11_5 DISPLAY=LABEL
  /TABLE codigo_gobierno_3_11 [C] BY numero_3_11 [S][SUM, COLPCT.SUM PCT40.1] + v3_11_2 [S][SUM, COLPCT.SUM PCT40.1]
   + v3_11_3 [S][SUM, COLPCT.SUM PCT40.1] + v3_11_4 [S][SUM, COLPCT.SUM PCT40.1] + v3_11_5 [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_3_11 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='PROYECTOS DE NUEVOS SISTEMAS DE DRENAJE, INVERSIN, BENEFICIARIOS, AREA REGADA Y BENEFICIARIOS, POR PROVINCIA'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 61. MONTOS DE FINANCIAMIENTO DE PROYECTOS DE NUEVOS SISTEMAS DE DRENAJE, POR PROVINCIA Y SEGN FUENTE DE FINANCIAMIENTO. 

FILTER BY Filtro_B.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_11 v3_11_7_gob v3_11_7_gadp v3_11_7_cooperante v3_11_7_usuarios v3_11_7_otro v3_11_7_total DISPLAY=LABEL
  /TABLE codigo_gobierno_3_11 [C] BY v3_11_7_gob [SUM] + v3_11_7_gadp [SUM] + v3_11_7_cooperante [SUM] + v3_11_7_usuarios [SUM]
  + v3_11_7_otro [SUM] + v3_11_7_total [SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_3_11 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='MONTOS DE FINANCIAMIENTO DE PROYECTOS DE NUEVOS SISTEMAS DE DRENAJE, POR PROVINCIA Y SEGN FUENTE DE FINANCIAMIENTO'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 62. PROYECTOS DE REHABILITACIN DE SISTEMAS DE DRENAJE, INVERSIN, BENEFICIARIOS, AREA REGADA Y BENEFICIARIOS, POR PROVINCIA.

COMPUTE Filtro_C = (tipo_3_11 = "c").
FILTER BY Filtro_C.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_11 numero_3_11 v3_11_2 v3_11_3 v3_11_4 v3_11_5 DISPLAY=LABEL
  /TABLE codigo_gobierno_3_11 [C] BY numero_3_11 [S][SUM, COLPCT.SUM PCT40.1] + v3_11_2 [S][SUM, COLPCT.SUM PCT40.1]
   + v3_11_3 [S][SUM, COLPCT.SUM PCT40.1] + v3_11_4 [S][SUM, COLPCT.SUM PCT40.1] + v3_11_5 [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_3_11 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='PROYECTOS DE REHABILITACIN DE SISTEMAS DE DRENAJE, INVERSIN, BENEFICIARIOS, AREA REGADA Y BENEFICIARIOS, POR PROVINCIA'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 63. MONTOS DE FINANCIAMIENTO DE PROYECTOS DE REHABILITACIN DE SISTEMAS DE DRENAJE, POR PROVINCIA Y SEGN FUENTE DE FINANCIAMIENTO. 

FILTER BY Filtro_C.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_11 v3_11_7_gob v3_11_7_gadp v3_11_7_cooperante v3_11_7_usuarios v3_11_7_otro v3_11_7_total DISPLAY=LABEL
  /TABLE codigo_gobierno_3_11 [C] BY v3_11_7_gob [SUM] + v3_11_7_gadp [SUM] + v3_11_7_cooperante [SUM] + v3_11_7_usuarios [SUM]
  + v3_11_7_otro [SUM] + v3_11_7_total [SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_3_11 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='MONTOS DE FINANCIAMIENTO DE PROYECTOS DE REHABILITACIN DE SISTEMAS DE DRENAJE, POR PROVINCIA Y SEGN FUENTE DE FINANCIAMIENTO'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 64. PROYECTOS DE TECNIFICACIN DE SISTEMAS DE DRENAJE, INVERSIN, BENEFICIARIOS, AREA REGADA Y BENEFICIARIOS, POR PROVINCIA.

COMPUTE Filtro_D = (tipo_3_11 = "d").
FILTER BY Filtro_D.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_11 numero_3_11 v3_11_2 v3_11_3 v3_11_4 v3_11_5 DISPLAY=LABEL
  /TABLE codigo_gobierno_3_11 [C] BY numero_3_11 [S][SUM, COLPCT.SUM PCT40.1] + v3_11_2 [S][SUM, COLPCT.SUM PCT40.1]
   + v3_11_3 [S][SUM, COLPCT.SUM PCT40.1] + v3_11_4 [S][SUM, COLPCT.SUM PCT40.1] + v3_11_5 [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_3_11 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='PROYECTOS DE TECNIFICACIN DE SISTEMAS DE DRENAJE, INVERSIN, BENEFICIARIOS, AREA REGADA Y BENEFICIARIOS, POR PROVINCIA'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 65. MONTOS DE FINANCIAMIENTO DE PROYECTOS DE TECNIFICACIN DE SISTEMAS DE DRENAJE, POR PROVINCIA Y SEGN FUENTE DE FINANCIAMIENTO. 

FILTER BY Filtro_D.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_11 v3_11_7_gob v3_11_7_gadp v3_11_7_cooperante v3_11_7_usuarios v3_11_7_otro v3_11_7_total DISPLAY=LABEL
  /TABLE codigo_gobierno_3_11 [C] BY v3_11_7_gob [SUM] + v3_11_7_gadp [SUM] + v3_11_7_cooperante [SUM] + v3_11_7_usuarios [SUM]
  + v3_11_7_otro [SUM] + v3_11_7_total [SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_3_11 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='MONTOS DE FINANCIAMIENTO DE PROYECTOS DE TECNIFICACIN DE SISTEMAS DE DRENAJE, POR PROVINCIA Y SEGN FUENTE DE FINANCIAMIENTO'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.

DELETE VARIABLES Filtro_A Filtro_B Filtro_C Filtro_D.


* TABLA 66. PROYECTOS DE ESTUDIOS DE FACTIBILIDAD DE SISTEMAS DE RIEGO Y DRENAJE, INVERSIN, BENEFICIARIOS, AREA REGADA, AREA DRENADA Y BENEFICIARIOS, POR PROVINCIA.

ALTER TYPE v3_12_2 (F9.2).
ALTER TYPE v3_12_5 (F6.2).
ALTER TYPE v3_12_6 (F6.2).

VARIABLE LEVEL codigo_gobierno_3_12 (NOMINAL).

IF (numero_3_12 = 0 & v3_12_2 = 0) v3_12_2 = $SYSMIS.
IF (numero_3_12 = 0 & v3_12_3 = 0) v3_12_3 = $SYSMIS.
IF (numero_3_12 = 0 & v3_12_4 = 0) v3_12_4 = $SYSMIS.
IF (numero_3_12 = 0 & v3_12_5 = 0) v3_12_5 = $SYSMIS.
IF (numero_3_12 = 0 & v3_12_6 = 0) v3_12_6 = $SYSMIS.
EXECUTE.

VARIABLE LEVEL numero_3_12 (SCALE).
VARIABLE LEVEL v3_12_2 v3_12_3 v3_12_4 v3_12_5 v3_12_6 (SCALE).

COMPUTE Filtro_A = (tipo_3_12 = "a").
FILTER BY Filtro_A.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_12 numero_3_12 v3_12_2 v3_12_3 v3_12_4 v3_12_5 v3_12_6 DISPLAY=LABEL
  /TABLE codigo_gobierno_3_12 [C] BY numero_3_12 [S][SUM, COLPCT.SUM PCT40.1] + v3_12_2 [S][SUM, COLPCT.SUM PCT40.1]
   + v3_12_3 [S][SUM, COLPCT.SUM PCT40.1] + v3_12_4 [S][SUM, COLPCT.SUM PCT40.1] + v3_12_5 [S][SUM, COLPCT.SUM PCT40.1]
   + v3_12_6 [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_3_12 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='PROYECTOS DE ESTUDIOS DE FACTIBILIDAD DE SISTEMAS DE RIEGO Y DRENAJE, INVERSIN, BENEFICIARIOS, AREA REGADA, AREA DRENADA Y BENEFICIARIOS, POR PROVINCIA'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 67. MONTOS DE FINANCIAMIENTO DE PROYECTOS DE ESTUDIOS DE FACTIBILIDAD DE SISTEMAS DE RIEGO Y DRENAJE, POR PROVINCIA Y SEGN FUENTE DE FINANCIAMIENTO. 

ALTER TYPE v3_12_8_gob v3_12_8_gadp v3_12_8_cooperante v3_12_8_usuarios v3_12_8_otro v3_12_8_total (F9.2).
VARIABLE LEVEL v3_12_8_gob v3_12_8_gadp v3_12_8_cooperante v3_12_8_usuarios v3_12_8_otro v3_12_8_total (SCALE).

FILTER BY Filtro_A.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_12 v3_12_8_gob v3_12_8_gadp v3_12_8_cooperante v3_12_8_usuarios v3_12_8_otro v3_12_8_total DISPLAY=LABEL
  /TABLE codigo_gobierno_3_12 [C] BY v3_12_8_gob [SUM] + v3_12_8_gadp [SUM] + v3_12_8_cooperante [SUM] + v3_12_8_usuarios [SUM]
  + v3_12_8_otro [SUM] + v3_12_8_total [SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_3_12 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='MONTOS DE FINANCIAMIENTO DE PROYECTOS DE ESTUDIOS DE FACTIBILIDAD DE SISTEMAS DE RIEGO Y DRENAJE, POR PROVINCIA Y SEGN FUENTE DE FINANCIAMIENTO'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 68. PROYECTOS DE NUEVOS SISTEMAS DE RIEGO Y DRENAJE, INVERSIN, BENEFICIARIOS, AREA REGADA Y AREA DRENADA, POR PROVINCIA.

COMPUTE Filtro_B = (tipo_3_12 = "b").
FILTER BY Filtro_B.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_12 numero_3_12 v3_12_2 v3_12_3 v3_12_4 v3_12_5 v3_12_6 DISPLAY=LABEL
  /TABLE codigo_gobierno_3_12 [C] BY numero_3_12 [S][SUM, COLPCT.SUM PCT40.1] + v3_12_2 [S][SUM, COLPCT.SUM PCT40.1]
   + v3_12_3 [S][SUM, COLPCT.SUM PCT40.1] + v3_12_4 [S][SUM, COLPCT.SUM PCT40.1] + v3_12_5 [S][SUM, COLPCT.SUM PCT40.1]
   + v3_12_6 [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_3_12 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='PROYECTOS DE NUEVOS SISTEMAS DE RIEGO Y DRENAJE, INVERSIN, BENEFICIARIOS, AREA REGADA Y AREA DRENADA, POR PROVINCIA'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.


* TABLA 69. MONTOS DE FINANCIAMIENTO DE NUEVOS SISTEMAS DE RIEGO Y DRENAJE, POR PROVINCIA Y SEGN FUENTE DE FINANCIAMIENTO. 

FILTER BY Filtro_B.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_3_12 v3_12_8_gob v3_12_8_gadp v3_12_8_cooperante v3_12_8_usuarios v3_12_8_otro v3_12_8_total DISPLAY=LABEL
  /TABLE codigo_gobierno_3_12 [C] BY v3_12_8_gob [SUM] + v3_12_8_gadp [SUM] + v3_12_8_cooperante [SUM] + v3_12_8_usuarios [SUM]
  + v3_12_8_otro [SUM] + v3_12_8_total [SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_3_12 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='MONTOS DE FINANCIAMIENTO DE NUEVOS SISTEMAS DE RIEGO Y DRENAJE, POR PROVINCIA Y SEGN FUENTE DE FINANCIAMIENTO'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.

FILTER OFF.

DELETE VARIABLES Filtro_A Filtro_B.


* TABLA 70. SISTEMAS DE DRENAJE, INVERSIN, BENEFICIARIOS Y REA DRENADA, POR PROVINCIA.
* Abrir base BDD2_RIEGO_GAD_2018.sav.

ALTER TYPE v3_9_2 v3_9_3 (F10.2).
VARIABLE LEVEL v3_9_1 v3_9_2 v3_9_3 (SCALE).

CTABLES
  /VLABELS VARIABLES=codigo_gobierno v3_9_1 v3_9_2 v3_9_3 DISPLAY=LABEL
  /TABLE codigo_gobierno [C] BY v3_9_1 [S][SUM, COLPCT.SUM PCT40.1] + v3_9_2 [S][SUM, COLPCT.SUM PCT40.1]
   + v3_9_3 [S][SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='SISTEMAS DE DRENAJE, INVERSIN, BENEFICIARIOS Y REA DRENADA, POR PROVINCIA'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.


* TABLA 71. GAD PROVINCIALES QUE IMPULSARON MECANISMOS DE ARTICULACIN EN PROYECTOS DE RIEGO Y DRENAJE, SEGN INSTITUCIONES.
* Abrir base BDD1_RIEGO_GAD_2018.sav.

CTABLES
  /VLABELS VARIABLES=instituciones_3_13 si_no_3_13 DISPLAY=LABEL
  /TABLE instituciones_3_13 [COUNT F40.0, ROWPCT.COUNT PCT40.1] BY si_no_3_13
  /CATEGORIES VARIABLES=instituciones_3_13 ORDER=A KEY=VALUE EMPTY=INCLUDE
  /CATEGORIES VARIABLES=si_no_3_13 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='GAD PROVINCIALES QUE IMPULSARON MECANISMOS DE ARTICULACIN EN PROYECTOS DE RIEGO Y DRENAJE, SEGN INSTITUCIONES'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.


* TABLA 72. TIPO DE MECANISMOS DE ARTICULACIN DE LOS GAD PROVINCIALES, SEGN INSTITUCIONES.

VARIABLE LEVEL v3_13_1_talleres v3_13_1_convenios v3_13_1_capacitacion (SCALE).

CTABLES
  /VLABELS VARIABLES=instituciones_3_13 v3_13_1_talleres v3_13_1_convenios v3_13_1_capacitacion DISPLAY=LABEL
  /TABLE instituciones_3_13 [C] BY v3_13_1_talleres [SUM] + v3_13_1_convenios [SUM] + v3_13_1_capacitacion [SUM]
  /CATEGORIES VARIABLES=instituciones_3_13 ORDER=A KEY=VALUE EMPTY=INCLUDE
  /TITLES
    TITLE='TIPO DE MECANISMOS DE ARTICULACIN DE LOS GAD PROVINCIALES, SEGN INSTITUCIONES'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.


* TABLA 73. INGRESOS DE LOS GAD PROVINCIALES PARA RIEGO Y DRENAJE POR FUENTE (PROGRAMADO).
* ABRIR base BDD2_RIEGO_GAD_2018.sav.

ALTER TYPE v3_14_1_a v3_14_2_a v3_14_1_b v3_14_2_b v3_14_1_c v3_14_2_c v3_14_1_d v3_14_2_d v3_14_1_e v3_14_2_e v3_14_1_f
 v3_14_2_f v3_14_1_g v3_14_2_g v3_14_1_total v3_14_2_total (F10.2).

VARIABLE LEVEL v3_14_1_a v3_14_2_a v3_14_1_b v3_14_2_b v3_14_1_c v3_14_2_c v3_14_1_d v3_14_2_d v3_14_1_e v3_14_2_e v3_14_1_f
 v3_14_2_f v3_14_1_g v3_14_2_g v3_14_1_total v3_14_2_total (SCALE).

CTABLES
  /VLABELS VARIABLES=codigo_gobierno v3_14_1_a v3_14_1_b v3_14_1_c v3_14_1_d v3_14_1_e v3_14_1_f  v3_14_1_g v3_14_1_total DISPLAY=LABEL
  /TABLE codigo_gobierno BY v3_14_1_a [SUM] + v3_14_1_b [SUM] + v3_14_1_c [SUM] + v3_14_1_d [SUM] + v3_14_1_e [SUM] 
   + v3_14_1_f [SUM] + v3_14_1_g [SUM] + v3_14_1_total [SUM]
  /CATEGORIES VARIABLES=codigo_gobierno ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='INGRESOS DE LOS GAD PROVINCIALES PARA RIEGO Y DRENAJE POR FUENTE (PROGRAMADO)'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.


* TABLA 74. INGRESOS DE LOS GAD PROVINCIALES PARA RIEGO Y DRENAJE POR FUENTE (DEVENGADO).

CTABLES
  /VLABELS VARIABLES=codigo_gobierno v3_14_2_a v3_14_2_b v3_14_2_c v3_14_2_d v3_14_2_e v3_14_2_f v3_14_2_g v3_14_2_total DISPLAY=LABEL
  /TABLE codigo_gobierno BY v3_14_2_a [SUM] + v3_14_2_b [SUM] + v3_14_2_c [SUM] + v3_14_2_d [SUM] + v3_14_2_e [SUM] 
   + v3_14_2_f [SUM] + v3_14_2_g [SUM] + v3_14_2_total [SUM]
  /CATEGORIES VARIABLES=codigo_gobierno ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES
    TITLE='INGRESOS DE LOS GAD PROVINCIALES PARA RIEGO Y DRENAJE POR FUENTE (DEVENGADO)'
    CAPTION='INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS (INEC) - CIAEGADP 2018'.


******************************************************************************************************************************************************************************

* CAPITULO IV- GESTIN DE RIESGOS 2018

* Tabla 75

CTABLES
  /VLABELS VARIABLES=v4_1 DISPLAY=LABEL
  /TABLE v4_1 [C][COUNT F40.0, TOTALS[COUNT F40.0]]
  /CATEGORIES VARIABLES=v4_1 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
/TITLES
    TITLE='NMERO GAD PROVINCIALES QUE CUENTAN CON PLAN DE GESTIN DE RIESGOS NATURALES'
    CAPTION='BDD_GESTIN_RIESGOS_GADS_2018'.


* Tabla 76

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_4_1 v4_1 DISPLAY=LABEL
  /TABLE codigo_gobierno_4_1 [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] BY v4_1 [C]
  /CATEGORIES VARIABLES=codigo_gobierno_4_1 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=v4_1 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
/TITLES
    TITLE='GAD PROVINCIALES QUE CUENTAN CON PLAN DE GESTIN DE RIESGOS NATURALES'
    CAPTION='BDD_GESTIN_RIESGOS_GADS_2018'.


* Tabla 77

COMPUTE v4_2_proyects=codigo_gobierno_4_2 >= 1 <= 24.
EXECUTE.

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_4_2 v4_2_proyects v4_2_6 DISPLAY=LABEL
  /TABLE codigo_gobierno_4_2 [C] BY v4_2_proyects [S][SUM] + v4_2_6 [S][SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_4_2 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
/TITLES
    TITLE='NMERO DE PROYECTOS E INVERSIN EN GESTIN DE RIESGOS NATURALES, SEGN GAD PROVINCIALES'
    CAPTION='BDD_GESTIN_RIESGOS_GADS_2018'.


****************************************************************************************************
* CAPITULO V- INGRESOS Y GASTOS 2018

* Tabla 78

DATASET ACTIVATE Conjunto_de_datos2.
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=v5_1_d v5_1_e v5_1_a v5_1_b v5_1_c v5_1_f DISPLAY=LABEL
  /TABLE v5_1_d [C][COUNT F40.0] + v5_1_e [C][COUNT F40.0] + v5_1_a [C][COUNT F40.0] + v5_1_b 
    [C][COUNT F40.0] + v5_1_c [C][COUNT F40.0] + v5_1_f [C][COUNT F40.0]
  /CATEGORIES VARIABLES=v5_1_d v5_1_e v5_1_a v5_1_b v5_1_c v5_1_f ORDER=A KEY=VALUE EMPTY=INCLUDE
/TITLES
    TITLE=' FUENTES DE INGRESO DE LOS GAD PROVINCIALES'
    CAPTION='BDD_GAD_INGRESOS_2018'.

* Tabla 79

CTABLES
  /VLABELS VARIABLES=v5_1_2_a v5_1_2_b v5_1_2_c v5_1_2_d v5_1_2_e v5_1_2_f DISPLAY=LABEL
  /TABLE v5_1_2_a [S][SUM] + v5_1_2_b [S][SUM] + v5_1_2_c [S][SUM] + v5_1_2_d [S][SUM] + v5_1_2_e 
    [S][SUM] + v5_1_2_f [S][SUM]
/TITLES
    TITLE='TOTAL MONTO CODIFICADO DE LOS GAD PROVINCIALES POR FUENTE DE INGRESO'
    CAPTION='BDD_GAD_INGRESOS_2018'.

* Tabla 80

CTABLES
  /VLABELS VARIABLES=codigo_gobierno v5_1_3_1_total v5_1_3_2_total v5_1_3_3_total v5_1_3_4_total 
    DISPLAY=LABEL
  /TABLE codigo_gobierno [C] BY v5_1_3_1_total [S][SUM] + v5_1_3_2_total [S][SUM] + v5_1_3_3_total 
    [S][SUM] + v5_1_3_4_total [S][SUM]
  /CATEGORIES VARIABLES=codigo_gobierno ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
/TITLES
    TITLE='MONTO DISTRIBUIDO POR COMPETENCIA, SEGN GAD PROVINCIALES'
    CAPTION='BDD_GAD_INGRESOS_2018'.


* Tabla 81

CTABLES
  /VLABELS VARIABLES=codigo_gobierno v5_3_total_programado v5_3_total_codificado 
    v5_3_total_devengado DISPLAY=LABEL
  /TABLE codigo_gobierno [C] BY v5_3_total_programado [S][SUM, COLPCT.SUM PCT40.1] + 
    v5_3_total_codificado [S][SUM, COLPCT.SUM PCT40.1] + v5_3_total_devengado [S][SUM, COLPCT.SUM 
    PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
/TITLES
    TITLE='GASTO EN  PROTECCIN Y GESTIN AMBIENTAL POR GAD PROVINCIAL'
    CAPTION='BDD_GAD_INGRESOS_2018'.



*************************************************************************************************************************************************
* CAPITULO VI- COOPERACIN INTERNACIONAL  2018


* Tabla 82

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_6_2 v6_2_1 v6_2_2 DISPLAY=LABEL
  /TABLE codigo_gobierno_6_2  [C] BY v6_2_1 [S][SUM, COLPCT.SUM PCT40.1] + v6_2_2 [S][SUM, COLPCT.SUM 
    PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_6_2 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
/TITLES
    TITLE='PERSONAL CON EL QUE CONT  LA COMPETENCIA DE COOPERACIN INTERNACIONAL, POR PROVINCIA'
    CAPTION='BDD_COOP_INTE_GADS_2018'.

* Tabla 83

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_6_2 cargo_perfil_6_2 v6_2_3 DISPLAY=LABEL
  /TABLE codigo_gobierno_6_2 [C] BY cargo_perfil_6_2 [C] > v6_2_3 [S][SUM, ROWPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_6_2 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=cargo_perfil_6_2 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
/TITLES
    TITLE='PERSONAL CON EL QUE CONT LA COMPETENCIA DE COOPERACIN INTERNACIONAL POR CARGO'
    CAPTION='BDD_COOP_INTE_GADS_2018'.


* Tabla 84

COMPUTE v6_3_gad_emision_normativa=codigo_gobierno_6_3  >= 1 <= 24.
EXECUTE.


CTABLES
  /VLABELS VARIABLES=v6_3_gad_emision_normativa v6_3_gad_emision_normativa_si_no DISPLAY=LABEL
  /TABLE v6_3_gad_emision_normativa [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] BY BY v6_3_gad_emision_normativa_si_no [C]    
  /CATEGORIES VARIABLES=v6_3_gad_emision_normativa ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=v6_3_gad_emision_normativa_si_no ORDER=A KEY=VALUE EMPTY=INCLUDE
/TITLES
    TITLE='GAD PROVINCIALES QUE EMITIERON INSTRUMENTOS DE PLANIFICACIN Y NORMATIVA LOCAL A FAVOR DE COOPERACIN INTERNACIONAL'
    CAPTION='BDD_COOP_INTE_GADS_2018'.
.

* Tabla 85  

CTABLES
  /VLABELS VARIABLES= codigo_gobierno_6_3 DISPLAY=LABEL
  /TABLE codigo_gobierno_6_3 [C][COUNT F40.0] BY v6_3_1 [C]
  /CATEGORIES VARIABLES=codigo_gobierno_6_3 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=v6_3_1 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=AFTER.
/TITLES
    TITLE='INSTRUMENTOS DE PLANIFICACIN Y NORMATIVA  LOCAL EMITIDOS A FAVOR DE COOPERACION INTERNACIONAL, SEGN GAD PROVINCIAL'
    CAPTION='BDD_COOP_INTE_GADS_2018'.


********************************************************************************************************************************************************

* CAPITULO VII- VIALIDAD  2018


* Tabla 86

  CTABLES
  /VLABELS VARIABLES=codigo_gobierno_7_2 v7_2_1 v7_2_2 DISPLAY=LABEL
  /TABLE codigo_gobierno_7_2  [C] BY v7_2_1 [S][SUM, COLPCT.SUM PCT40.1] + v7_2_2 [S][SUM, COLPCT.SUM 
    PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_7_2 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
/TITLES
    TITLE='PERSONAL CON EL QUE CONT LA COMPETENCIA VIALIDAD'
    CAPTION='BDD_2_VIALI_GADS_2018'.


* Tabla 87

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_7_2 cargo_perfil_7_2 v7_2_3 DISPLAY=LABEL
  /TABLE codigo_gobierno_7_2 [C] BY cargo_perfil_7_2 [C] > v7_2_3 [S][SUM, ROWPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=codigo_gobierno_7_2 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
  /CATEGORIES VARIABLES=cargo_perfil_7_2 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
/TITLES
    TITLE='PERSONAL CON EL QUE CONT LA COMPETENCIA VIALIDAD POR CARGO'
    CAPTION='BDD_2_VIALI_GADS_2018'.


* Tabla 88

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_7_9 v7_9_6 DISPLAY=LABEL
  /TABLE codigo_gobierno_7_9 [C] BY v7_9_6 [S][SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_7_9 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
/TITLES
    TITLE='INVERSIN DE PROYECTOS EN VIALIDAD VIAS'
    CAPTION='BDD_2_VIALI_GADS_2018'.

* Tabla 89

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_7_9 v7_9_8_1 v7_9_8_2 v7_9_8_3 v7_9_8_4 v7_9_8_5 v7_9_8_6
    DISPLAY=LABEL
  /TABLE codigo_gobierno_7_9 BY v7_9_8_1 [SUM] + v7_9_8_2 [SUM] + v7_9_8_3 [SUM] + 
    v7_9_8_4 [SUM] + v7_9_8_5 [SUM] + v7_9_8_6 [SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_7_9 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
/TITLES
    TITLE='MONTO POR FUENTES DE FINANCIAMIENTO PARA PROYECTOS DE VIALIDAD EN VIAS, SEGN GAD PROVINCIAL'
    CAPTION='BDD_2_VIALI_GADS_2018'.

* Tabla 90

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_7_9_1 v7_9_17 DISPLAY=LABEL
  /TABLE codigo_gobierno_7_9_1 [C] BY v7_9_17 [S][SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_7_9_1 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
/TITLES
    TITLE='INVERSIN DE PROYECTOS EN VIALIDAD EN PUENTES'
    CAPTION='BDD_2_VIALI_GADS_2018'.


* Tabla 91

CTABLES
  /VLABELS VARIABLES=codigo_gobierno_7_9_1 v7_9_19_1 v7_9_19_2 v7_9_19_3 v7_9_19_4 v7_9_19_5
    v7_9_19_6
    DISPLAY=LABEL
  /TABLE codigo_gobierno_7_9_1 BY v7_9_19_1 [SUM] + v7_9_19_2 [SUM] + v7_9_19_3 [SUM] + 
    v7_9_19_4 [SUM] + v7_9_19_5 [SUM] + v7_9_19_6 [SUM]
  /CATEGORIES VARIABLES=codigo_gobierno_7_9_1 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES 
    POSITION=BEFORE
/TITLES
    TITLE='MONTO POR FUENTES DE FINANCIAMIENTO PARA PROYECTOS DE VIALIDAD EN PUENTES , SEGN GAD PROVINCIAL'
    CAPTION='BDD_2_VIALI_GADS_2018'.


*** *****************************************************FIN DE LA SINTAXIS  GAD 2018.****************************************************
